/* 
   Copyright (C) 1997,1998 by Didier Frick (dfrick@dial.eunet.ch)

   $Id: Diapo.java,v 1.38 1999/07/13 17:26:21 dfrick Exp $

   This software may be freely modified and redistributed, provided this comment
   is left in the source. 

   If you make modifications or improvements to the code, you should add your
   name and e-mail address below, with a description of the changes.

   Name			E-mail			Description

   Didier Frick		dfrick@dial.eunet.ch	Initial release

*/

// package ch.dfr.diapo;

import java.awt.*;
import java.awt.image.*;
import java.applet.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.*;

/**
 * The diaporama applet class
 *
 * @version $Id: Diapo.java,v 1.38 1999/07/13 17:26:21 dfrick Exp $
 * @author Didier Frick (dfrick@dial.eunet.ch)
 */
public class Diapo extends java.applet.Applet {
    protected int between=5;
    protected int delay=100; /* ms */
    protected int mainDelay=2500;
    protected String message="Java Programming: Didier Frick <dfrick@dial.eunet.ch>";
    protected String target="_blank";
    protected Image img;
    protected FadingImageSource src;
    protected Vector images;
    protected URL link;
    protected Thread thread;
    protected ThreadGroup threadGroup;


    /**
     * This flag is used to downgrade the behavior of this class if it is running in a
     * "problematic" environment like Netscape on the Macintosh.
     * If it is true, only the first image will be displayed
     */
    protected static boolean minimal=true;

    static {
	try {
	    String vendor=System.getProperty("java.vendor").toLowerCase();
	    String os=System.getProperty("os.name").toLowerCase();
	    minimal=vendor.startsWith("netscape")&&os.startsWith("mac");
	} catch(Exception xc) {
	    xc.printStackTrace();
	}
    }

    /**
     * Read the applet parameter values
     */
    public void init() {

	try {
	    between=Integer.parseInt(getParameter("between"));
	} catch (Exception x) {
	    ;
	}

	try {
	    mainDelay=Integer.parseInt(getParameter("mainDelay"));
	} catch (Exception x) {
	    ;
	}
    
	try {
	    delay=Integer.parseInt(getParameter("delay"));
	} catch (Exception x) {
	    ;
	}

	try {
	    link=new URL(getDocumentBase(),getParameter("link"));
	} catch (Exception x) {
	    ;
	}

	String param;
	param=getParameter("target");
	if(param!=null)
	    target=param;

	param=getParameter("message");
	if(param!=null)
	    message=param;

	images=new Vector();
	for(int nImages=0;(param=getParameter("image"+(nImages+1)))!=null; nImages++) {
	    try {
		Image i=getImage(getDocumentBase(),param);
		if(i!=null) {
		    images.addElement(i);
		    if(minimal)
			break;
		}
	    } catch (Exception x) {
		;
	    }
	}
	if(!minimal) {
	    threadGroup=Thread.currentThread().getThreadGroup();
	    src=new FadingImageSource(images,
				      between,
				      mainDelay,
				      delay,
				      bounds().width,
				      bounds().height);
	    img=createImage(src);
	} else {
	    img=(Image)images.elementAt(0);
	}
    }

    /**
     * Override update to suppress flashing
     */
    public void update(Graphics g) {
	paint(g);
    }

    /**
     * The paint method: draw the animated image if defined, otherwise
     * clear the background.
     */
    public void paint(Graphics g) {
	if(img!=null)
	    g.drawImage(img,0,0,this);
    }

    /**
     * The start method: create the ImageProducer and animated image
     */
    public void start() {
	thread=new Thread(threadGroup,src);
	thread.start();
	repaint();
    }

    /**
     * The stop method stops the animation thread
     */
    public void stop() {
	if(thread!=null)
	    thread.stop();
	thread=null;
    }

    public void destroy() {
	src=null;
	img=null;
	images=null;
	System.gc();
    }

    public String getAppletInfo() {
	return "Diaporama $Revision: 1.38 $, Copyright (C) 1997,1998 by Didier Frick (dfrick@dial.eunet.ch)";
    }

    public String[][] getParameterInfo() {
	return pinfo;
    }

    private String pinfo[][] = {
	{ "between", "int", "Number of interpolated images between each image"},
	{ "mainDelay", "int", "Time to display a non-interpolated image (ms)"},
	{ "delay", "int", "Time to display an interpolated image (ms)"},
	{ "link", "URL", "Document to show when user clicks on applet"},
	{ "target", "String", "Frame in which to display link"},
	{ "message", "String", "Text to display in status bar when mouse cursor enters applet"},
	{ "image1", "URL", "First image. Used via Applet.getImage"},
	{ "image2", "URL", "Next image. And so on... (without gaps)"}
    };

    /**
     * Display message if mouse cursor enters applet.
     */
    public boolean mouseEnter(Event evt,
			     int x,
			     int y) {
	showStatus(message);
	return true;
    }

    /**
     * Display linked document if mouse clicked
     */
    public boolean mouseDown(Event evt,
			     int x,
			     int y) {
	if(link!=null)
	    getAppletContext().showDocument(link,target);
	return true;
    }

}
